<?php

namespace App\Http\Controllers;

use App\Models\Invoice;

class DashboardController extends Controller
{
    public function index()
    {
        // حساب عدد الفواتير، إجمالي الأرباح (المجموع قبل الضريبة)، وإجمالي الضريبة
        $invoiceCount = Invoice::count();
        $totalProfit = (float) Invoice::sum('subtotal');
        $totalTax = (float) Invoice::sum('tax');

        // أحدث الفواتير
        $latestInvoices = Invoice::orderByDesc('created_at')
            ->limit(5)
            ->get(['id','number','customer_name','date','total','status','created_at']);

        return view('dashboard', [
            'invoiceCount' => $invoiceCount,
            'totalProfit' => $totalProfit,
            'totalTax' => $totalTax,
            'latestInvoices' => $latestInvoices,
        ]);
    }
}