<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use App\Models\Setting;

class SettingsController extends Controller
{
    public function edit()
    {
        $setting = Setting::query()->first();
        return view('settings.edit', ['setting' => $setting]);
    }

    public function update(Request $request)
    {
        $validated = $request->validate([
            'company_name' => ['nullable', 'string', 'max:255'],
            'company_address' => ['nullable', 'string', 'max:500'],
            'company_phone' => ['nullable', 'string', 'max:100'],
            'company_email' => ['nullable', 'email', 'max:255'],
            'company_tax_number' => ['nullable', 'string', 'max:100'],
            'logo' => ['nullable', 'image', 'mimes:png,jpg,jpeg,webp', 'max:2048'],
        ]);

        $setting = Setting::query()->first();
        if (!$setting) {
            $setting = new Setting();
        }

        if ($request->hasFile('logo')) {
            // Delete old logo if exists
            if ($setting->company_logo_path && Storage::disk('public')->exists($setting->company_logo_path)) {
                Storage::disk('public')->delete($setting->company_logo_path);
            }
            $path = $request->file('logo')->store('company', 'public');
            $setting->company_logo_path = $path;
        }

        $setting->company_name = $validated['company_name'] ?? $setting->company_name;
        $setting->company_address = $validated['company_address'] ?? $setting->company_address;
        $setting->company_phone = $validated['company_phone'] ?? $setting->company_phone;
        $setting->company_email = $validated['company_email'] ?? $setting->company_email;
        $setting->company_tax_number = $validated['company_tax_number'] ?? $setting->company_tax_number;
        $setting->save();

        return redirect()->route('settings.edit')->with('success', __('تم حفظ الإعدادات بنجاح'));
    }
}