@extends('layouts.app')

@section('title', 'لوحة التحكم')

@section('content')
<div class="bg-hero rounded-3xl p-8 text-white mb-8">
    <h1 class="text-3xl font-bold">لوحة التحكم</h1>
    <p class="mt-2 text-white/80">نظرة عامة سريعة على نظام الفواتير</p>
</div>

<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
    <div class="card p-6">
        <div class="text-sm text-neutral-500">عدد الفواتير</div>
        <div class="text-3xl font-bold mt-2">{{ number_format($invoiceCount ?? 0) }}</div>
    </div>
    <div class="card p-6">
        <div class="text-sm text-neutral-500">إجمالي الأرباح</div>
        <div class="text-3xl font-bold mt-2">{{ number_format(($totalProfit ?? 0), 2) }} ر.س</div>
    </div>
    <div class="card p-6">
        <div class="text-sm text-neutral-500">إجمالي الضريبة</div>
        <div class="text-3xl font-bold mt-2">{{ number_format(($totalTax ?? 0), 2) }} ر.س</div>
    </div>
</div>

<div class="card shadow-xl ring-1 ring-neutral-200/70 rounded-2xl px-4 md:px-6 py-5 mt-8">
    <h2 class="text-xl font-bold mb-4">آخر العمليات</h2>
    @if(!empty($latestInvoices) && count($latestInvoices) > 0)
        <div class="overflow-hidden rounded-xl border border-neutral-200">
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead class="bg-neutral-50 sticky top-0 z-10">
                        <tr class="text-gray-700">
                            <th class="p-4 text-right">رقم الفاتورة</th>
                            <th class="p-4 text-right">العميل</th>
                            <th class="p-4 text-right">التاريخ</th>
                            <th class="p-4 text-right">الإجمالي</th>
                            <th class="p-4 text-right">الحالة</th>
                            <th class="p-4 text-right">الإجراءات</th>
                        </tr>
                    </thead>
                    <tbody class="bg-white">
                        @foreach($latestInvoices as $inv)
                            @php
                                $status = $inv->status;
                                $badgeBg = $status === 'مسدد' ? 'bg-green-100 text-green-700' : ($status === 'غير مسدد' ? 'bg-red-100 text-red-700' : 'bg-yellow-100 text-yellow-700');
                                $dot = $status === 'مسدد' ? 'bg-green-600' : ($status === 'غير مسدد' ? 'bg-red-600' : 'bg-yellow-600');
                            @endphp
                            <tr class="border-t hover:bg-neutral-50/80 transition-colors">
                                <td class="p-4 align-middle font-semibold text-black">
                                    <a href="{{ route('invoices.show', $inv->id) }}" class="text-black hover:text-black">{{ $inv->number }}</a>
                                </td>
                                <td class="p-4 align-middle text-black">{{ $inv->customer_name }}</td>
                                <td class="p-4 align-middle text-black">{{ optional($inv->date)->toDateString() }}</td>
                                <td class="p-4 align-middle font-semibold text-black text-ltr">{{ number_format($inv->total ?? 0, 2) }} ر.س</td>
                                <td class="p-4 align-middle">
                                    <span class="inline-flex items-center gap-2 px-2.5 py-1 rounded-full text-xs {{ $badgeBg }} text-black">
                                        <span class="h-1.5 w-1.5 rounded-full {{ $dot }}"></span>
                                        {{ $status }}
                                    </span>
                                </td>
                                <td class="p-4 align-middle">
                                    <div class="flex items-center gap-2 flex-wrap">
                                        <a href="{{ route('invoices.show', $inv->id) }}" class="btn-secondary text-xs inline-flex items-center gap-1 text-black" title="مشاهدة"><i class="fa-solid fa-eye text-xs"></i> مشاهدة</a>
                                        <a href="{{ route('invoices.edit', $inv->id) }}" class="btn-secondary text-xs inline-flex items-center gap-1 text-black" title="تعديل"><i class="fa-solid fa-pen-to-square text-xs"></i> تعديل</a>
                                        <a href="{{ route('invoices.pdf', $inv->id) }}" class="btn-secondary text-xs inline-flex items-center gap-1 text-black" title="PDF" target="_blank" rel="noopener"><i class="fa-solid fa-file-pdf text-xs"></i> PDF</a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    @else
        <div class="text-neutral-600 dark:text-neutral-300">لا توجد فواتير حديثة.</div>
    @endif
</div>
@endsection