@extends('layouts.app')

@section('title', 'الفواتير')

@section('content')
<div class="min-h-screen fancy-bg">
    <div class="container mx-auto px-4 md:px-6 lg:px-8 py-10">
        <div class="flex items-center justify-between gap-4 mb-8">
            <div>
                <h1 class="text-3xl md:text-4xl font-extrabold tracking-tight text-gray-900">الفواتير</h1>
                <p class="mt-1 text-gray-600">عرض جميع الفواتير مع إمكانية التحديد الجماعي وتنفيذ الإجراءات</p>
            </div>
            <div class="flex items-center gap-3">
                <a href="{{ route('invoices.create') }}" class="btn-primary inline-flex items-center gap-2" title="إنشاء فاتورة جديدة">
                    <i class="fa-solid fa-plus text-sm"></i>
                    إنشاء فاتورة
                </a>
            </div>
        </div>

        <!-- بطاقة الفلاتر -->
        <div class="card shadow-lg ring-1 ring-neutral-200/70 rounded-2xl px-4 md:px-6 py-5 mb-6">
            <form action="{{ route('invoices.index') }}" method="GET" class="space-y-4">
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">رقم الفاتورة</label>
                        <input type="text" name="number" value="{{ request('number') }}" placeholder="مثال: INV-001" class="w-full rounded-lg border border-neutral-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-violet-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">الحالة</label>
                        <select name="status" class="w-full rounded-lg border border-neutral-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-violet-500">
                            <option value="">كل الحالات</option>
                            <option value="مسدد" {{ request('status') === 'مسدد' ? 'selected' : '' }}>مسدد</option>
                            <option value="غير مسدد" {{ request('status') === 'غير مسدد' ? 'selected' : '' }}>غير مسدد</option>
                            <option value="معلق" {{ request('status') === 'معلق' ? 'selected' : '' }}>معلق</option>
                        </select>
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">تاريخ من</label>
                        <input type="date" name="date_from" value="{{ request('date_from') }}" class="w-full rounded-lg border border-neutral-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-violet-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">تاريخ إلى</label>
                        <input type="date" name="date_to" value="{{ request('date_to') }}" class="w-full rounded-lg border border-neutral-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-violet-500">
                    </div>
                </div>
                <div class="grid grid-cols-1 md:grid-cols-4 gap-4">
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">الحد الأدنى للإجمالي</label>
                        <input type="number" step="0.01" name="total_min" value="{{ request('total_min') }}" placeholder="0.00" class="w-full rounded-lg border border-neutral-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-violet-500">
                    </div>
                    <div>
                        <label class="block text-sm font-medium text-gray-700 mb-1">الحد الأقصى للإجمالي</label>
                        <input type="number" step="0.01" name="total_max" value="{{ request('total_max') }}" placeholder="0.00" class="w-full rounded-lg border border-neutral-300 px-3 py-2 focus:outline-none focus:ring-2 focus:ring-violet-500">
                    </div>
                    <div class="md:col-span-2 flex items-end gap-3">
                        <button type="submit" class="btn-primary">تصفية</button>
                        <a href="{{ route('invoices.index') }}" id="reset_filters" class="btn-secondary">إعادة تعيين</a>
                    </div>
                </div>
                <div class="text-sm text-gray-600 mt-1">
                    عدد النتائج: <span class="font-semibold text-gray-900">{{ $invoices->count() }}</span>
                    من <span class="font-semibold text-gray-900">{{ $totalCount ?? $invoices->count() }}</span>
                </div>
            </form>
        </div>

        <!-- بطاقة الجدول والإجراءات -->
        <div class="card shadow-xl ring-1 ring-neutral-200/70 rounded-2xl px-4 md:px-6 py-5">
            <div class="flex items-center justify-between gap-3 mb-6">
                <div class="flex items-center gap-4 flex-wrap">
                    <label class="inline-flex items-center gap-2 text-sm text-gray-700">
                        <input id="select_all" type="checkbox" class="accent-violet-600 h-4 w-4 rounded">
                        تحديد الكل
                    </label>
                    <button id="bulk_delete" class="btn-secondary inline-flex items-center gap-2" disabled>
                        <i class="fa-solid fa-trash text-sm"></i>
                        حذف المحدد
                    </button>
                </div>
                <div class="text-xs md:text-sm text-gray-500">
                    المحدد:
                    <span id="selected_count" class="inline-flex items-center px-2 py-1 rounded-full bg-neutral-100 text-gray-700">0</span>
                </div>
            </div>

            <div class="overflow-hidden rounded-xl border border-neutral-200">
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-neutral-50 sticky top-0 z-10">
                            <tr class="text-gray-700">
                                <th class="p-4 text-right w-12">#</th>
                                <th class="p-4 text-right {{ request('sort_by') === 'number' ? 'bg-violet-50 text-violet-800 border-b-2 border-violet-600' : '' }}">
                                    <a href="{{ route('invoices.index', array_merge(request()->query(), ['sort_by' => 'number', 'sort_dir' => request('sort_by') === 'number' && request('sort_dir', 'asc') === 'asc' ? 'desc' : 'asc'])) }}" class="inline-flex items-center gap-1 hover:text-violet-700 {{ request('sort_by') === 'number' ? 'font-semibold' : '' }}">
                                        رقم الفاتورة
                                        @if(request('sort_by') === 'number')
                                            @if(request('sort_dir','asc') === 'asc')
                                                <i class="fa-solid fa-sort-up text-violet-700"></i>
                                            @else
                                                <i class="fa-solid fa-sort-down text-violet-700"></i>
                                            @endif
                                        @else
                                            <i class="fa-solid fa-sort text-neutral-400"></i>
                                        @endif
                                    </a>
                                </th>
                                <th class="p-4 text-right {{ request('sort_by') === 'customer' ? 'bg-violet-50 text-violet-800 border-b-2 border-violet-600' : '' }}">
                                    <a href="{{ route('invoices.index', array_merge(request()->query(), ['sort_by' => 'customer', 'sort_dir' => request('sort_by') === 'customer' && request('sort_dir', 'asc') === 'asc' ? 'desc' : 'asc'])) }}" class="inline-flex items-center gap-1 hover:text-violet-700 {{ request('sort_by') === 'customer' ? 'font-semibold' : '' }}">
                                        العميل
                                        @if(request('sort_by') === 'customer')
                                            @if(request('sort_dir','asc') === 'asc')
                                                <i class="fa-solid fa-sort-up text-violet-700"></i>
                                            @else
                                                <i class="fa-solid fa-sort-down text-violet-700"></i>
                                            @endif
                                        @else
                                            <i class="fa-solid fa-sort text-neutral-400"></i>
                                        @endif
                                    </a>
                                </th>
                                <th class="p-4 text-right {{ request('sort_by') === 'date' ? 'bg-violet-50 text-violet-800 border-b-2 border-violet-600' : '' }}">
                                    <a href="{{ route('invoices.index', array_merge(request()->query(), ['sort_by' => 'date', 'sort_dir' => request('sort_by') === 'date' && request('sort_dir', 'asc') === 'asc' ? 'desc' : 'asc'])) }}" class="inline-flex items-center gap-1 hover:text-violet-700 {{ request('sort_by') === 'date' ? 'font-semibold' : '' }}">
                                        التاريخ
                                        @if(request('sort_by') === 'date')
                                            @if(request('sort_dir','asc') === 'asc')
                                                <i class="fa-solid fa-sort-up text-violet-700"></i>
                                            @else
                                                <i class="fa-solid fa-sort-down text-violet-700"></i>
                                            @endif
                                        @else
                                            <i class="fa-solid fa-sort text-neutral-400"></i>
                                        @endif
                                    </a>
                                </th>
                                <th class="p-4 text-right {{ request('sort_by') === 'total' ? 'bg-violet-50 text-violet-800 border-b-2 border-violet-600' : '' }}">
                                    <a href="{{ route('invoices.index', array_merge(request()->query(), ['sort_by' => 'total', 'sort_dir' => request('sort_by') === 'total' && request('sort_dir', 'asc') === 'asc' ? 'desc' : 'asc'])) }}" class="inline-flex items-center gap-1 hover:text-violet-700 {{ request('sort_by') === 'total' ? 'font-semibold' : '' }}">
                                        الإجمالي
                                        @if(request('sort_by') === 'total')
                                            @if(request('sort_dir','asc') === 'asc')
                                                <i class="fa-solid fa-sort-up text-violet-700"></i>
                                            @else
                                                <i class="fa-solid fa-sort-down text-violet-700"></i>
                                            @endif
                                        @else
                                            <i class="fa-solid fa-sort text-neutral-400"></i>
                                        @endif
                                    </a>
                                </th>
                                <th class="p-4 text-right {{ request('sort_by') === 'status' ? 'bg-violet-50 text-violet-800 border-b-2 border-violet-600' : '' }}">
                                    <a href="{{ route('invoices.index', array_merge(request()->query(), ['sort_by' => 'status', 'sort_dir' => request('sort_by') === 'status' && request('sort_dir', 'asc') === 'asc' ? 'desc' : 'asc'])) }}" class="inline-flex items-center gap-1 hover:text-violet-700 {{ request('sort_by') === 'status' ? 'font-semibold' : '' }}">
                                        الحالة
                                        @if(request('sort_by') === 'status')
                                            @if(request('sort_dir','asc') === 'asc')
                                                <span class="text-violet-700">↑</span>
                                            @else
                                                <span class="text-violet-700">↓</span>
                                            @endif
                                        @else
                                            <span class="text-neutral-400">↕</span>
                                        @endif
                                    </a>
                                </th>
                                <th class="p-4 text-right">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white">
                            @forelse($invoices as $invoice)
                                @php
                                    $status = $invoice['status'];
                                    $badgeBg = $status === 'مسدد' ? 'bg-green-100 text-green-700' : ($status === 'غير مسدد' ? 'bg-red-100 text-red-700' : 'bg-yellow-100 text-yellow-700');
                                    $dot = $status === 'مسدد' ? 'bg-green-600' : ($status === 'غير مسدد' ? 'bg-red-600' : 'bg-yellow-600');
                                @endphp
                                <tr class="border-t hover:bg-neutral-50/80 transition-colors">
                                    <td class="p-4 align-middle">
                                        <input type="checkbox" class="row-check accent-violet-600 h-4 w-4 rounded" value="{{ $invoice['id'] }}">
                                    </td>
                                    <td class="p-4 align-middle font-semibold text-black">{{ $invoice['number'] }}</td>
                                    <td class="p-4 align-middle text-black">{{ $invoice['customer'] }}</td>
                                    <td class="p-4 align-middle text-black">{{ $invoice['date'] }}</td>
                                    <td class="p-4 align-middle font-semibold text-black">{{ number_format($invoice['total'], 2) }} ر.س</td>
                                    <td class="p-4 align-middle">
                                        <span class="inline-flex items-center gap-2 px-2.5 py-1 rounded-full text-xs font-medium {{ $badgeBg }} text-black">
                                            <span class="h-1.5 w-1.5 rounded-full {{ $dot }}"></span>
                                            {{ $status }}
                                        </span>
                                    </td>
                                    <td class="p-4 align-middle">
                                        <div class="flex items-center gap-2 flex-wrap">
                                            <a href="{{ route('invoices.show', $invoice['id']) }}" class="btn-secondary text-xs inline-flex items-center gap-1 text-black" title="مشاهدة"><i class="fa-solid fa-eye text-xs"></i> مشاهدة</a>
                                            <a href="{{ route('invoices.edit', $invoice['id']) }}" class="btn-secondary text-xs inline-flex items-center gap-1 text-black" title="تعديل"><i class="fa-solid fa-pen-to-square text-xs"></i> تعديل</a>
                                            <form method="POST" action="{{ route('invoices.destroy', $invoice['id']) }}" onsubmit="return confirm('هل أنت متأكد من حذف هذه الفاتورة؟');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn-secondary text-xs inline-flex items-center gap-1 text-black hover:bg-red-50" title="حذف">
                                                    <i class="fa-solid fa-trash text-xs"></i>
                                                    حذف
                                                </button>
                                            </form>
                                    </div>
                                    </td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="7" class="p-6 text-center text-gray-500">لا توجد فواتير مطابقة للفلاتر الحالية</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <script>
            document.addEventListener('DOMContentLoaded', function() {
                const selectAll = document.getElementById('select_all');
                const rowChecks = Array.from(document.querySelectorAll('.row-check'));
                const bulkDelete = document.getElementById('bulk_delete');
                const selectedCount = document.getElementById('selected_count');

                const updateRowVisual = (cb) => {
                    const tr = cb.closest('tr');
                    if (!tr) return;
                    tr.classList.toggle('bg-violet-50', cb.checked);
                };

                const updateState = () => {
                    const selected = rowChecks.filter(cb => cb.checked).map(cb => cb.value);
                    selectedCount.textContent = selected.length;
                    bulkDelete.disabled = selected.length === 0;
                };

                if (selectAll) {
                    selectAll.addEventListener('change', () => {
                        rowChecks.forEach(cb => { cb.checked = selectAll.checked; updateRowVisual(cb); });
                        updateState();
                    });
                }

                rowChecks.forEach(cb => cb.addEventListener('change', () => {
                    const allChecked = rowChecks.length > 0 && rowChecks.every(c => c.checked);
                    if (selectAll) selectAll.checked = allChecked;
                    updateRowVisual(cb);
                    updateState();
                }));

                bulkDelete.addEventListener('click', () => {
                    const selected = rowChecks.filter(cb => cb.checked).map(cb => cb.value);
                    if (selected.length === 0) return;
                    if (confirm(`سيتم حذف ${selected.length} فاتورة (محاكاة). هل أنت متأكد؟`)) {
                        alert('تمت عملية الحذف (محاكاة — الواجهة فقط).');
                    }
                });

                updateState();
            });
        </script>
    </div>
</div>
@endsection