<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>فاتورة رقم {{ $invoice->id }}</title>
    <style>
        @font-face {
            font-family: 'Alexandria';
            src: url('{{ public_path("fonts/Alexandria-Regular.ttf") }}') format('truetype');
            font-weight: normal;
            font-style: normal;
        }
        @font-face {
            font-family: 'Alexandria';
            src: url('{{ public_path("fonts/Alexandria-Bold.ttf") }}') format('truetype');
            font-weight: bold;
            font-style: normal;
        }
        html, body {
            direction: rtl;
            text-align: right;
            font-family: 'Alexandria', 'DejaVu Sans', Tahoma, serif;
            font-size: 14px;
            color: #111827;
            margin: 0;
            padding: 0;
        }
        /* دعم RTL واضح مع إمكانية مزج نصوص LTR عند الحاجة */
        .rtl { direction: rtl; unicode-bidi: embed; }
        .text-ltr { direction: ltr; unicode-bidi: embed; text-align: left; }

        .container {
            padding: 24px;
        }
        .header {
            display: flex;
            align-items: center;
            justify-content: space-between;
            margin-bottom: 16px;
        }
        .company-info {
            display: flex;
            flex-direction: column;
            gap: 4px; /* spacing between lines */
            max-width: 70%;
        }
        .company-info .name {
            font-weight: bold;
            font-size: 18px;
            margin-bottom: 6px; /* extra space below company name */
        }
        .invoice-meta {
            border-top: 2px solid #e5e7eb;
            padding-top: 12px;
            margin-bottom: 16px;
            display: grid;
            grid-template-columns: 1fr 1fr 1fr;
            gap: 10px;
        }
        .meta-item {
            display: flex;
            flex-direction: column;
            gap: 4px;
            font-size: 13px;
        }
        .meta-label { color: #6b7280; }
        .meta-value { color: #111827; font-weight: 600; }

        .details {
            width: 100%;
            border-collapse: collapse;
            margin-top: 8px;
        }
        .details th, .details td {
            border: 1px solid #e5e7eb;
            padding: 8px 10px;
            text-align: right;
        }
        .details th { background: #f3f4f6; }

        .totals {
            margin-top: 16px;
            width: 320px;
            margin-left: auto;
        }
        .totals .row { display: flex; justify-content: space-between; padding: 6px 0; }
        .totals .label { color: #6b7280; }
        .totals .value { font-weight: 700; color: #111827; }

        .footer {
            margin-top: 24px;
            font-size: 12px;
            color: #6b7280;
        }
        .qr {
            width: 160px;
            height: 160px;
            border: 1px solid #e5e7eb;
            border-radius: 4px;
            display: flex;
            align-items: center;
            justify-content: center;
        }
        .logo {
            width: 120px;
            height: auto;
            object-fit: contain;
        }
    </style>
</head>
<body class="rtl">
    <div class="container">
        <div class="header">
            <div class="company-info">
                @if(!empty($setting?->company_name))
                    <div class="name">{{ $setting->company_name }}</div>
                @endif
                @if(!empty($setting?->company_address))
                    <div>{{ $setting->company_address }}</div>
                @endif
                @if(!empty($setting?->company_phone))
                    <div>هاتف: {{ $setting->company_phone }}</div>
                @endif
                @if(!empty($setting?->company_email))
                    <div>البريد الإلكتروني: {{ $setting->company_email }}</div>
                @endif
                @if(!empty($setting?->company_tax_number))
                    <div>الرقم الضريبي: {{ $setting->company_tax_number }}</div>
                @endif
            </div>
            <div class="qr">
                @if(!empty($qrDataUri))
                    <img src="{{ $qrDataUri }}" alt="ZATCA QR" style="width: 160px; height: 160px;" />
                @endif
            </div>
            @if(!empty($logoDataUri))
                <img class="logo" src="{{ $logoDataUri }}" alt="شعار الشركة" />
            @endif
        </div>

        <div class="invoice-meta">
            <div class="meta-item">
                <div class="meta-label">رقم الفاتورة</div>
                <div class="meta-value text-ltr">REF-{{ $invoice->id }}</div>
            </div>
            <div class="meta-item">
                <div class="meta-label">تاريخ الفاتورة</div>
                <div class="meta-value">{{ ($invoice->date ?? $invoice->created_at)->format('Y-m-d') }}</div>
            </div>
            <div class="meta-item">
                <div class="meta-label">العميل</div>
                <div class="meta-value">{{ $invoice->customer_name }}</div>
            </div>
        </div>

        <table class="details">
            <thead>
                <tr>
                    <th>الوصف</th>
                    <th>الكمية</th>
                    <th>السعر</th>
                    <th>الإجمالي</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoice->items as $item)
                    <tr>
                        <td>{{ $item->description }}</td>
                        <td class="text-ltr">{{ number_format($item->quantity, 0) }}</td>
                        <td class="text-ltr">{{ number_format($item->unit_price, 2) }}</td>
                        <td class="text-ltr">{{ number_format($item->line_total, 2) }}</td>
                    </tr>
                @endforeach
            </tbody>
        </table>

        <div class="totals">
            <div class="row">
                <div class="label">المجموع</div>
                <div class="value text-ltr">{{ number_format($invoice->subtotal, 2) }}</div>
            </div>
            <div class="row">
                <div class="label">الضريبة (15%)</div>
                <div class="value text-ltr">{{ number_format($invoice->tax, 2) }}</div>
            </div>
            <div class="row" style="border-top: 1px solid #e5e7eb; margin-top: 6px; padding-top: 8px;">
                <div class="label">الإجمالي النهائي</div>
                <div class="value text-ltr">{{ number_format($invoice->total, 2) }}</div>
            </div>
        </div>

        <div class="footer">
            تم إنشاء هذه الفاتورة تلقائيًا.
        </div>
    </div>
</body>
</html>