@extends('layouts.app')

@section('title', 'عروض الأسعار')

@section('content')
<div class="min-h-screen fancy-bg">
    <div class="container mx-auto px-4 md:px-6 lg:px-8 py-10">
        <div class="flex items-center justify-between gap-4 mb-8">
            <div>
                <h1 class="text-3xl md:text-4xl font-extrabold tracking-tight text-gray-900">عروض الأسعار</h1>
                <p class="mt-1 text-gray-600">عرض جميع عروض الأسعار بنفس استايل الفواتير</p>
            </div>
            <div class="flex items-center gap-3">
                <a href="{{ route('quotes.create') }}" class="btn-primary inline-flex items-center gap-2" title="إنشاء عرض سعر جديد">
                    <i class="fa-solid fa-plus text-sm"></i>
                    إنشاء عرض سعر
                </a>
            </div>
        </div>

        <!-- بطاقة الجدول -->
        <div class="card shadow-xl ring-1 ring-neutral-200/70 rounded-2xl px-4 md:px-6 py-5">
            <div class="overflow-hidden rounded-xl border border-neutral-200">
                <div class="overflow-x-auto">
                    <table class="min-w-full text-sm">
                        <thead class="bg-neutral-50">
                            <tr class="text-gray-700">
                                <th class="p-4 text-right">رقم العرض</th>
                                <th class="p-4 text-right">اسم العميل</th>
                                <th class="p-4 text-right">التاريخ</th>
                                <th class="p-4 text-right">الإجمالي</th>
                                <th class="p-4 text-right">الحالة</th>
                                <th class="p-4 text-right">الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody class="bg-white">
                            @foreach($quotes as $quote)
                                <tr class="border-t hover:bg-neutral-50/80 transition-colors">
                                    <td class="p-4 align-middle font-semibold text-black">{{ $quote['number'] }}</td>
                                    <td class="p-4 align-middle text-black">{{ $quote['customer_name'] }}</td>
                                    <td class="p-4 align-middle text-black">{{ $quote['date'] }}</td>
                                    <td class="p-4 align-middle font-semibold text-black">{{ number_format($quote['total'], 2) }} ر.س</td>
                                    <td class="p-4 align-middle">
                                        <span class="inline-flex items-center gap-2 px-2.5 py-1 rounded-full text-xs font-medium bg-neutral-100 text-black">
                                            {{ $quote['status'] }}
                                        </span>
                                    </td>
                                    <td class="p-4 align-middle">
                                        <div class="flex items-center gap-2 flex-wrap">
                                            <a href="{{ route('quotes.show', $quote['id']) }}" class="btn-secondary text-xs inline-flex items-center gap-1 text-black" title="مشاهدة"><i class="fa-solid fa-eye text-xs"></i> مشاهدة</a>
                                            <a href="{{ route('quotes.edit', $quote['id']) }}" class="btn-secondary text-xs inline-flex items-center gap-1 text-black" title="تعديل"><i class="fa-solid fa-pen-to-square text-xs"></i> تعديل</a>
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection