@extends('layouts.app')

@section('title', 'إعدادات الشركة')

@section('content')
<div class="max-w-3xl mx-auto">
    @if(session('success'))
        <div class="alert mb-6">{{ session('success') }}</div>
    @endif

    <div class="card p-6">
        <h1 class="text-2xl font-bold mb-4">إعدادات الشركة</h1>
        <form method="POST" action="{{ route('settings.update') }}" enctype="multipart/form-data" class="grid grid-cols-1 gap-5">
            @csrf

            <div>
                <label for="company_name" class="block mb-2">اسم الشركة</label>
                <input id="company_name" name="company_name" type="text" class="input" value="{{ old('company_name', $setting->company_name ?? '') }}" placeholder="مثال: شركة الإبداع للتقنية">
            </div>

            <div>
                <label for="company_address" class="block mb-2">عنوان الشركة</label>
                <input id="company_address" name="company_address" type="text" class="input" value="{{ old('company_address', $setting->company_address ?? '') }}" placeholder="المدينة، الشارع، المبنى">
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-5">
                <div>
                    <label for="company_phone" class="block mb-2">رقم الشركة</label>
                    <input id="company_phone" name="company_phone" type="text" class="input" value="{{ old('company_phone', $setting->company_phone ?? '') }}" placeholder="05xxxxxxxx">
                </div>
                <div>
                    <label for="company_email" class="block mb-2">البريد الإلكتروني للشركة</label>
                    <input id="company_email" name="company_email" type="email" class="input" value="{{ old('company_email', $setting->company_email ?? '') }}" placeholder="company@example.com">
                </div>
            </div>

            <div>
                <label for="company_tax_number" class="block mb-2">الرقم الضريبي</label>
                <input id="company_tax_number" name="company_tax_number" type="text" class="input" value="{{ old('company_tax_number', $setting->company_tax_number ?? '') }}" placeholder="XXXXXXXXXX">
            </div>

            <div>
                <label class="block mb-2">شعار الشركة</label>
                <div class="flex items-center gap-4">
                    <input type="file" name="logo" accept="image/*" class="input">
                    @if(!empty($setting?->company_logo_path))
                        <img src="{{ asset('storage/' . $setting->company_logo_path) }}" alt="شعار الشركة" class="h-12 w-12 rounded-lg border">
                    @endif
                </div>
            </div>

            <div class="flex justify-end gap-3 mt-4">
                <a href="{{ route('dashboard') }}" class="btn-secondary">إلغاء</a>
                <button type="submit" class="btn-primary">حفظ الإعدادات</button>
            </div>
        </form>
    </div>
</div>
@endsection