@extends('layouts.app')

@section('title', 'بيانات المدير')

@section('content')
<div class="max-w-3xl mx-auto">
    @if(session('success'))
        <div class="alert mb-6">{{ session('success') }}</div>
    @endif

    <div class="card p-6">
        <h1 class="text-2xl font-bold mb-4">بيانات المدير</h1>
        <form id="user_settings_form" action="{{ route('user.settings.update') }}" method="POST" class="grid grid-cols-1 gap-5">
                @csrf

                <!-- البريد الإلكتروني -->
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700">البريد الإلكتروني</label>
                    <input id="email" name="email" type="email" value="{{ old('email', $user->email) }}" class="input mt-1" placeholder="example@domain.com" autocomplete="email" required>
                    @error('email')
                        <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                    @enderror
                </div>

                <!-- كلمة المرور الحالية والجديدة -->
                <div class="space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-5 items-start">
                        <div>
                            <label for="current_password" class="block text-sm font-medium text-gray-700">كلمة المرور الحالية</label>
                            <div class="relative mt-1">
                                <input id="current_password" name="current_password" type="password" class="input pr-10" placeholder="••••••••" autocomplete="current-password">
                                <button type="button" class="absolute inset-y-0 left-2 text-neutral-500 hover:text-neutral-700 text-sm" data-toggle="password" data-target="#current_password">إظهار</button>
                            </div>
                            @error('current_password')
                                <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                            <p class="mt-2 text-xs text-gray-500">لن تتغيّر كلمة المرور إلا إذا أدخلت الحالية.</p>
                        </div>

                        <div>
                            <label for="password" class="block text-sm font-medium text-gray-700">كلمة المرور الجديدة</label>
                            <div class="relative mt-1">
                                <input id="password" name="password" type="password" class="input pr-10" placeholder="••••••••" autocomplete="new-password">
                                <button type="button" class="absolute inset-y-0 left-2 text-neutral-500 hover:text-neutral-700 text-sm" data-toggle="password" data-target="#password">إظهار</button>
                            </div>
                            @error('password')
                                <p class="mt-2 text-sm text-red-600">{{ $message }}</p>
                            @enderror
                        </div>
                    </div>

                    <div>
                        <label for="password_confirmation" class="block text-sm font-medium text-gray-700">تأكيد كلمة المرور الجديدة</label>
                        <div class="relative mt-1">
                            <input id="password_confirmation" name="password_confirmation" type="password" class="input pr-10" placeholder="••••••••" autocomplete="new-password">
                            <button type="button" class="absolute inset-y-0 left-2 text-neutral-500 hover:text-neutral-700 text-sm" data-toggle="password" data-target="#password_confirmation">إظهار</button>
                        </div>
                    </div>
                </div>

                <div class="flex justify-end gap-3 mt-4">
                    <a href="{{ route('dashboard') }}" class="btn-secondary">إلغاء</a>
                    <button id="save_btn" type="submit" class="btn-primary">حفظ التغييرات</button>
                </div>
        </form>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // تبديل إظهار/إخفاء كلمات المرور
        document.querySelectorAll('[data-toggle="password"]').forEach(function(btn) {
            btn.addEventListener('click', function() {
                var selector = btn.getAttribute('data-target');
                var input = document.querySelector(selector);
                if (!input) return;
                var isPassword = input.type === 'password';
                input.type = isPassword ? 'text' : 'password';
                btn.textContent = isPassword ? 'إخفاء' : 'إظهار';
            });
        });

        // تعطيل زر الحفظ أثناء الإرسال لمنع النقر المكرر
        var form = document.getElementById('user_settings_form');
        var saveBtn = document.getElementById('save_btn');
        if (form && saveBtn) {
            form.addEventListener('submit', function() {
                saveBtn.disabled = true;
                saveBtn.textContent = 'جارٍ الحفظ...';
            });
        }
    });
</script>
@endsection