<?php $__env->startSection('title', 'بيانات المدير'); ?>

<?php $__env->startSection('content'); ?>
<div class="max-w-3xl mx-auto">
    <?php if(session('success')): ?>
        <div class="alert mb-6"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <div class="card p-6">
        <h1 class="text-2xl font-bold mb-4">بيانات المدير</h1>
        <form id="user_settings_form" action="<?php echo e(route('user.settings.update')); ?>" method="POST" class="grid grid-cols-1 gap-5">
                <?php echo csrf_field(); ?>

                <!-- البريد الإلكتروني -->
                <div>
                    <label for="email" class="block text-sm font-medium text-gray-700">البريد الإلكتروني</label>
                    <input id="email" name="email" type="email" value="<?php echo e(old('email', $user->email)); ?>" class="input mt-1" placeholder="example@domain.com" autocomplete="email" required>
                    <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                </div>

                <!-- كلمة المرور الحالية والجديدة -->
                <div class="space-y-4">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-5 items-start">
                        <div>
                            <label for="current_password" class="block text-sm font-medium text-gray-700">كلمة المرور الحالية</label>
                            <div class="relative mt-1">
                                <input id="current_password" name="current_password" type="password" class="input pr-10" placeholder="••••••••" autocomplete="current-password">
                                <button type="button" class="absolute inset-y-0 left-2 text-neutral-500 hover:text-neutral-700 text-sm" data-toggle="password" data-target="#current_password">إظهار</button>
                            </div>
                            <?php $__errorArgs = ['current_password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            <p class="mt-2 text-xs text-gray-500">لن تتغيّر كلمة المرور إلا إذا أدخلت الحالية.</p>
                        </div>

                        <div>
                            <label for="password" class="block text-sm font-medium text-gray-700">كلمة المرور الجديدة</label>
                            <div class="relative mt-1">
                                <input id="password" name="password" type="password" class="input pr-10" placeholder="••••••••" autocomplete="new-password">
                                <button type="button" class="absolute inset-y-0 left-2 text-neutral-500 hover:text-neutral-700 text-sm" data-toggle="password" data-target="#password">إظهار</button>
                            </div>
                            <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <p class="mt-2 text-sm text-red-600"><?php echo e($message); ?></p>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                        </div>
                    </div>

                    <div>
                        <label for="password_confirmation" class="block text-sm font-medium text-gray-700">تأكيد كلمة المرور الجديدة</label>
                        <div class="relative mt-1">
                            <input id="password_confirmation" name="password_confirmation" type="password" class="input pr-10" placeholder="••••••••" autocomplete="new-password">
                            <button type="button" class="absolute inset-y-0 left-2 text-neutral-500 hover:text-neutral-700 text-sm" data-toggle="password" data-target="#password_confirmation">إظهار</button>
                        </div>
                    </div>
                </div>

                <div class="flex justify-end gap-3 mt-4">
                    <a href="<?php echo e(route('dashboard')); ?>" class="btn-secondary">إلغاء</a>
                    <button id="save_btn" type="submit" class="btn-primary">حفظ التغييرات</button>
                </div>
        </form>
    </div>
</div>

<script>
    document.addEventListener('DOMContentLoaded', function() {
        // تبديل إظهار/إخفاء كلمات المرور
        document.querySelectorAll('[data-toggle="password"]').forEach(function(btn) {
            btn.addEventListener('click', function() {
                var selector = btn.getAttribute('data-target');
                var input = document.querySelector(selector);
                if (!input) return;
                var isPassword = input.type === 'password';
                input.type = isPassword ? 'text' : 'password';
                btn.textContent = isPassword ? 'إخفاء' : 'إظهار';
            });
        });

        // تعطيل زر الحفظ أثناء الإرسال لمنع النقر المكرر
        var form = document.getElementById('user_settings_form');
        var saveBtn = document.getElementById('save_btn');
        if (form && saveBtn) {
            form.addEventListener('submit', function() {
                saveBtn.disabled = true;
                saveBtn.textContent = 'جارٍ الحفظ...';
            });
        }
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\invoicesystem\resources\views/user/settings.blade.php ENDPATH**/ ?>