<?php $__env->startSection('title', 'عرض سعر'); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen fancy-bg">
    <div class="container mx-auto px-4 md:px-6 lg:px-8 py-10">
        <div class="flex items-center justify-between gap-4 mb-6">
            <h1 class="text-3xl md:text-4xl font-extrabold tracking-tight text-gray-900">عرض السعر</h1>
            <div class="flex items-center gap-3">
                <a href="<?php echo e(route('quotes.index')); ?>" class="btn-secondary inline-flex items-center gap-2"><i class="fa-solid fa-arrow-right text-sm"></i> عودة للقائمة</a>
                <button onclick="window.print()" class="btn-primary inline-flex items-center gap-2"><i class="fa-solid fa-print text-sm"></i> طباعة</button>
            </div>
        </div>

        <div id="quote_print_area" class="card shadow-xl ring-1 ring-neutral-200/70 rounded-2xl px-4 md:px-6 py-6">
            <!-- رأس الشركة -->
            <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-5 mb-6">
                <div class="flex items-center gap-6">
                    <?php if(!empty($setting?->company_logo_path)): ?>
                        <img src="<?php echo e(asset('storage/' . $setting->company_logo_path)); ?>" alt="شعار الشركة" class="h-24 w-40 md:h-28 md:w-48 rounded-lg object-contain"/>
                    <?php else: ?>
                        <div class="h-24 w-40 md:h-28 md:w-48 rounded-lg bg-neutral-100 flex items-center justify-center text-neutral-400">LOGO</div>
                    <?php endif; ?>
                    <div>
                        <div class="text-2xl md:text-3xl font-extrabold text-gray-900 mb-2"><?php echo e($setting->company_name ?? '—'); ?></div>
                        <div class="text-gray-600">العنوان : <span class="font-medium text-gray-900"><?php echo e($setting->company_address ?? '—'); ?></span></div>
                        <div class="text-gray-600">رقم ضريبي: <span class="font-medium text-gray-900"><?php echo e($setting->company_tax_number ?? '—'); ?></span></div>
                        <div class="text-gray-600">هاتف: <span class="font-medium text-gray-900"><?php echo e($setting->company_phone ?? '—'); ?></span></div>
                    </div>
                </div>
                <?php if(!empty($qrCodeSvg)): ?>
                    <div class="shrink-0">
                        <div class="text-xs text-gray-500 text-center mb-1">رمز عرض السعر (ZATCA)</div>
                        <div class="bg-white border rounded-lg p-2"><?php echo $qrCodeSvg; ?></div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- فاصل كامل العرض -->
            <div class="w-full border-t-2 border-neutral-300 my-8"></div>

            <!-- عنوان العرض بعد الفاصل -->
            <h2 class="text-center text-xl md:text-2xl font-black text-black mb-4">عرض سعر</h2>

            <!-- معلومات العرض -->
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4 mb-6">
                <div class="p-4 rounded-lg bg-neutral-50 border">
                    <div class="text-sm text-gray-600">رقم العرض</div>
                    <div class="text-lg font-semibold text-gray-900"><?php echo e($quote->number); ?></div>
                </div>
                <div class="p-4 rounded-lg bg-neutral-50 border">
                    <div class="text-sm text-gray-600">الرقم المرجعي</div>
                    <div class="text-lg font-semibold text-gray-900"><?php echo e('REF-' . $quote->id); ?></div>
                </div>
                <div class="p-4 rounded-lg bg-neutral-50 border">
                    <div class="text-sm text-gray-600">التاريخ</div>
                    <div class="text-lg font-semibold text-gray-900"><?php echo e($quote->date); ?></div>
                </div>
            </div>

            <!-- بيانات العميل -->
            <div class="mb-6">
                <h2 class="text-lg font-bold text-gray-900 mb-3">بيانات العميل</h2>
                <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                    <div class="p-4 rounded-lg bg-white border">
                        <div class="text-sm text-gray-600">الاسم</div>
                        <div class="text-base font-medium text-gray-900"><?php echo e($quote->customer_name); ?></div>
                    </div>
                    <div class="p-4 rounded-lg bg-white border">
                        <div class="text-sm text-gray-600">رقم الهاتف</div>
                        <div class="text-base font-medium text-gray-900"><?php echo e($quote->customer_phone); ?></div>
                    </div>
                    <?php if(!empty($quote->customer_address)): ?>
                        <div class="p-4 rounded-lg bg-white border md:col-span-2">
                            <div class="text-sm text-gray-600">العنوان</div>
                            <div class="text-base font-medium text-gray-900"><?php echo e($quote->customer_address); ?></div>
                        </div>
                    <?php endif; ?>
                    <?php if(!empty($quote->customer_tax_number)): ?>
                        <div class="p-4 rounded-lg bg-white border md:col-span-2">
                            <div class="text-sm text-gray-600">الرقم الضريبي للعميل</div>
                            <div class="text-base font-medium text-gray-900"><?php echo e($quote->customer_tax_number); ?></div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>

            <!-- جدول الخدمات -->
            <div class="mb-6">
                <h2 class="text-lg font-bold text-gray-900 mb-3">الخدمات</h2>
                <div class="overflow-hidden rounded-xl border border-neutral-200">
                    <div class="overflow-x-auto">
                        <table class="min-w-full text-sm">
                            <thead class="bg-neutral-50">
                                <tr class="text-gray-700">
                                    <th class="p-3 text-right w-12">#</th>
                                    <th class="p-3 text-right">الوصف</th>
                                    <th class="p-3 text-right">الكمية</th>
                                    <th class="p-3 text-right">سعر الوحدة</th>
                                    <th class="p-3 text-right">الإجمالي الفرعي</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white">
                                <?php $__empty_1 = true; $__currentLoopData = $quote->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr class="border-t">
                                        <td class="p-3 align-middle"><?php echo e($i + 1); ?></td>
                                        <td class="p-3 align-middle"><?php echo e($item['description']); ?></td>
                                        <td class="p-3 align-middle"><?php echo e($item['quantity']); ?></td>
                                        <td class="p-3 align-middle"><?php echo e(number_format($item['unit_price'], 2)); ?> ر.س</td>
                                        <td class="p-3 align-middle font-semibold text-black"><?php echo e(number_format($item['unit_price'] * $item['quantity'], 2)); ?> ر.س</td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="p-4 text-center text-gray-500">لا توجد بنود لهذا العرض</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

            <!-- الإجماليات -->
            <div class="flex flex-col items-end gap-2">
                <div class="w-full md:w-1/2 lg:w-1/3">
                    <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-neutral-50">
                        <div class="text-gray-700">الإجمالي الفرعي</div>
                        <div class="font-semibold text-black"><?php echo e(number_format($quote->subtotal, 2)); ?> ر.س</div>
                    </div>
                    <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-neutral-50 mt-2">
                        <div class="text-gray-700">ضريبة القيمة المضافة (15%)</div>
                        <div class="font-semibold text-gray-900"><?php echo e(number_format($quote->tax, 2)); ?> ر.س</div>
                    </div>
                    <div class="flex items-center justify-between px-4 py-2 border rounded-lg bg-violet-50 mt-2">
                        <div class="text-black font-bold">الإجمالي النهائي</div>
                        <div class="font-extrabold text-black"><?php echo e(number_format($quote->total, 2)); ?> ر.س</div>
                    </div>
                </div>
            </div>

            <!-- فوتر داخل الجزئية -->
            <div class="w-full border-t border-neutral-300 mt-6 mb-2"></div>
            <div class="text-center text-sm text-neutral-600">
                جميع الحقوق محفوظة © <?php echo e(now()->year); ?> لـ <?php echo e($setting->company_name ?? '—'); ?>

            </div>
        </div>
    </div>
</div>

<style>
  @media print {
    body * { visibility: hidden; }
    #quote_print_area, #quote_print_area * { visibility: visible; }
    #quote_print_area { position: absolute; inset: 0; margin: 0; padding: 0; }

    header, footer, nav, .no-print, .btn-primary, .btn-secondary { display: none !important; }
    main.container { padding: 0 !important; }
  }
</style>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\invoicesystem\resources\views/quotes/show.blade.php ENDPATH**/ ?>