<header class="navbar bg-white">
  <style>
    /* إخفاء زر القائمة وفرض عرض نظيف للقائمة على الديسكتوب */
    @media (min-width: 768px) {
      #menuToggle { display: none !important; }
      #mainNav {
        display: flex !important;
        background: transparent !important;
        box-shadow: none !important;
        border: none !important;
        padding: 0 !important;
        border-radius: 0 !important;
      }
    }
  </style>
  <div class="container mx-auto px-4 py-3 flex items-center justify-between gap-3 flex-wrap md:flex-nowrap">
    <!-- يسار: اللوجو + زر موبايل + قائمة نظيفة -->
    <div class="flex items-center gap-4 md:gap-3 md:flex-none">
      <!-- Logo / Brand -->
      <a href="<?php echo e(route('home')); ?>" class="flex items-center">
        <img src="<?php echo e(asset('images/login-logo.png')); ?>" alt="Logo" class="h-12 md:h-14 w-auto object-contain" />
      </a>

      <!-- زر فتح القائمة (موبايل فقط) -->
      <button id="menuToggle" type="button" class="inline-flex items-center gap-2 md:hidden px-3 py-2 rounded-md border text-gray-700 hover:bg-gray-50" aria-controls="mainNav" aria-expanded="false" aria-label="فتح القائمة">
        <i class="fa-solid fa-bars text-xl"></i>
        <span>القائمة</span>
      </button>

      </div>
      <!-- وسط: القائمة تكون في المنتصف على الديسكتوب، وتظهر كسطر كامل على الموبايل عند الفتح -->
      <div class="w-full md:flex flex-1 justify-center">
        <nav id="mainNav" class="hidden md:flex w-full md:w-auto mt-3 md:mt-0 flex-col md:flex-row items-stretch md:items-center md:justify-center gap-2 md:gap-3 bg-white md:bg-transparent rounded-xl md:rounded-none ring-1 ring-neutral-200 md:ring-0 shadow-sm md:shadow-none p-2 md:p-0" role="navigation" aria-label="القائمة الرئيسية">
          <a href="<?php echo e(route('home')); ?>" class="flex items-center !whitespace-nowrap min-w-0 gap-2 md:gap-1 px-3 md:px-2 py-2 rounded-md w-full md:w-auto text-sm md:text-base text-gray-700 hover:bg-gray-50 hover:text-indigo-600 <?php echo e(request()->routeIs('home') ? 'text-indigo-600 font-medium bg-gray-50' : ''); ?>">
            <i class="fa-solid fa-house text-lg md:text-xl"></i>
            <span class="truncate whitespace-nowrap">الرئيسية</span>
          </a>
          <a href="<?php echo e(route('invoices.index')); ?>" class="flex items-center !whitespace-nowrap min-w-0 gap-2 md:gap-1 px-3 md:px-2 py-2 rounded-md w-full md:w-auto text-sm md:text-base text-gray-700 hover:bg-gray-50 hover:text-indigo-600 <?php echo e(request()->routeIs('invoices.*') ? 'text-indigo-600 font-medium bg-gray-50' : ''); ?>">
            <i class="fa-solid fa-file-invoice text-lg md:text-xl"></i>
            <span class="truncate whitespace-nowrap">الفواتير</span>
          </a>
          <a href="<?php echo e(route('quotes.index')); ?>" class="flex items-center !whitespace-nowrap min-w-0 gap-2 md:gap-1 px-3 md:px-2 py-2 rounded-md w-full md:w-auto text-sm md:text-base text-gray-700 hover:bg-gray-50 hover:text-indigo-600 <?php echo e(request()->routeIs('quotes.*') ? 'text-indigo-600 font-medium bg-gray-50' : ''); ?>">
            <i class="fa-solid fa-file-lines text-lg md:text-xl"></i>
            <span class="truncate whitespace-nowrap">عروض الأسعار</span>
          </a>
          <a href="<?php echo e(route('settings.edit')); ?>" class="flex items-center !whitespace-nowrap min-w-0 gap-2 md:gap-1 px-3 md:px-2 py-2 rounded-md w-full md:w-auto text-sm md:text-base text-gray-700 hover:bg-gray-50 hover:text-indigo-600 <?php echo e(request()->routeIs('settings.*') ? 'text-indigo-600 font-medium bg-gray-50' : ''); ?>">
            <i class="fa-solid fa-gear text-lg md:text-xl"></i>
            <span class="truncate whitespace-nowrap">إعدادات النظام</span>
          </a>
        </nav>
      </div>
    <!-- يمين: إجراءات المستخدم تبقى كما هي -->
    <div class="flex items-center gap-3 md:gap-4 flex-wrap md:flex-nowrap">
      <?php if(auth()->guard()->check()): ?>
        <a href="https://wa.me/201111933193" target="_blank" rel="noopener" class="inline-flex items-center gap-2 px-3 py-2 rounded-md border text-sm md:text-base text-green-700 hover:bg-green-50">
           <i class="fa-brands fa-whatsapp text-lg"></i>
           <span>الدعم الفني</span>
         </a>
        <a href="<?php echo e(route('user.settings.edit')); ?>" class="inline-flex items-center gap-2 px-3 py-2 rounded-md border text-sm md:text-base text-gray-700 hover:bg-gray-50">
          <i class="fa-solid fa-user-gear text-sm"></i>
          <span>بيانات المدير</span>
        </a>
        <form method="POST" action="<?php echo e(route('logout')); ?>" class="inline-block">
          <?php echo csrf_field(); ?>
          <button type="submit" class="inline-flex items-center gap-2 px-3 py-2 rounded-md border text-sm md:text-base text-gray-700 hover:bg-gray-50">
            <i class="fa-solid fa-right-from-bracket text-sm"></i>
            <span>تسجيل الخروج</span>
          </button>
        </form>
      <?php else: ?>
        <a href="https://wa.me/201111933193" target="_blank" rel="noopener" class="inline-flex items-center gap-2 px-3 py-2 rounded-md border text-sm md:text-base text-green-700 hover:bg-green-50">
           <i class="fa-brands fa-whatsapp text-lg"></i>
           <span>الدعم الفني</span>
         </a>
         <a href="<?php echo e(route('login')); ?>" class="inline-flex items-center gap-2 px-3 py-2 rounded-md border text-sm md:text-base text-gray-700 hover:bg-gray-50">
           <i class="fa-solid fa-right-to-bracket text-xl"></i>
           <span>تسجيل الدخول</span>
         </a>
      <?php endif; ?>
    </div>
  </div>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
      var menuBtn = document.getElementById('menuToggle');
      var mainNav = document.getElementById('mainNav');
      function isDesktop() { return window.innerWidth >= 768; }
      function resetForViewport() {
        if (mainNav) {
          if (isDesktop()) {
            mainNav.classList.remove('hidden');
          } else {
            mainNav.classList.add('hidden');
          }
        }
      }
      if (menuBtn && mainNav) {
        menuBtn.addEventListener('click', function(e) {
          e.stopPropagation();
          if (!isDesktop()) {
            mainNav.classList.toggle('hidden');
            var expanded = !mainNav.classList.contains('hidden');
            menuBtn.setAttribute('aria-expanded', expanded ? 'true' : 'false');
          }
        });
        document.addEventListener('click', function(e) {
          if (!isDesktop() && !mainNav.classList.contains('hidden')) {
            var clickInsideNav = mainNav.contains(e.target);
            var clickOnToggle = menuBtn.contains(e.target);
            if (!clickInsideNav && !clickOnToggle) {
              mainNav.classList.add('hidden');
              menuBtn.setAttribute('aria-expanded', 'false');
            }
          }
        });
      }
      resetForViewport();
      window.addEventListener('resize', resetForViewport);
    });
  </script>
</header><?php /**PATH C:\xampp\htdocs\invoicesystem\resources\views/layouts/partials/header.blade.php ENDPATH**/ ?>